<?php
/*
  █████╗ ██████╗ ██╗  ██╗██╗   ██╗ █████╗ ██╗   ██╗██╗   ████████╗
 ██╔══██╗██╔══██╗██║ ██╔╝██║   ██║██╔══██╗██║   ██║██║   ╚══██╔══╝
 ███████║██████╔╝█████╔╝ ██║   ██║███████║██║   ██║██║      ██║
 ██╔══██║██╔═══╝ ██╔═██╗ ╚██╗ ██╔╝██╔══██║██║   ██║██║      ██║
 ██║  ██║██║     ██║  ██╗ ╚████╔╝ ██║  ██║╚██████╔╝███████╗ ██║
 ╚═╝  ╚═╝╚═╝     ╚═╝  ╚═╝  ╚═══╝  ╚═╝  ╚═╝ ╚═════╝ ╚══════╝ ╚═╝

                APKVAULT PANEL
                by @Phantom_681
                https://t.me/Phantom_681
*/
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($panelName); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" crossorigin="anonymous">
    <link href="assets/css/theme.css" rel="stylesheet">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <?php if ($logoUrl): ?>
                    <img src="<?php echo e($logoUrl); ?>" alt="Panel Logo" style="height: 32px; margin-right: 0.5rem; vertical-align: middle;">
                <?php endif; ?>
                <?php echo e($panelName); ?>
            </div>
        </div>
        
        <nav>
            <ul class="sidebar-nav">
                <?php foreach ($tabs as $tabKey => $tab): ?>
                    <li class="sidebar-nav-item">
                        <a href="<?php echo url('index.php?tab=' . $tabKey); ?>" 
                           class="sidebar-nav-link <?php echo $currentTab === $tabKey ? 'active' : ''; ?>">
                            <i class="bi <?php echo $tab['icon']; ?>"></i>
                            <span><?php echo e($tab['label']); ?></span>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </nav>
    </aside>

    <main class="main-content">
        <div class="top-bar">
            <div class="top-bar-left">
                <button class="sidebar-toggle" id="sidebarToggle" aria-label="Toggle sidebar">
                    <i class="bi bi-list"></i>
                </button>
                <h1>
                    <?php
                    $currentTabInfo = $tabs[$currentTab] ?? $tabs['dashboard'];
                    echo '<i class="bi ' . $currentTabInfo['icon'] . '"></i> ' . e($currentTabInfo['label']);
                    ?>
                </h1>
            </div>
            <div class="top-bar-actions">
                <div class="user-info">
                    <i class="bi bi-person-circle"></i>
                    <span><?php echo e($user['username'] ?? 'admin'); ?></span>
                </div>
                <a href="<?php echo url('index.php?logout=1'); ?>" class="btn btn-danger btn-sm">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </div>
        </div>

        <?php
        $successMsg = getFlashMessage('success');
        $errorMsg = getFlashMessage('error');
        if ($successMsg):
        ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e($successMsg); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <?php if ($errorMsg): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e($errorMsg); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

